/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.attributefix;

import java.io.File;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationHandler {
    public static final Logger log = LogManager.getLogger((String)"AttributeFix");
    public static Configuration config;

    public ConfigurationHandler(File file) {
        config = new Configuration(file);
        if (config.hasCategory("attributes")) {
            log.warn("Outdated AttributeFix config file detected! Please regenerate and reconfigure.");
        }
    }

    public void configureRangedAttribute(RangedAttribute attribute) {
        String name = attribute.func_111108_a().replace("generic.", "");
        double oldMin = attribute.field_111120_a;
        double oldMax = attribute.field_111118_b;
        config.addCustomCategoryComment(name, "Options for the " + name + " attribute.");
        boolean modifyMax = config.getBoolean("modifyMax", name, true, "Should the max value be modified?");
        float maximumValue = config.getFloat("max", name, this.getAdjustedAmount((float)attribute.field_111118_b), -3.4028235E38f, Float.MAX_VALUE, "The maximum amount for the " + name + " attribute.");
        boolean modifyMin = config.getBoolean("modifyMin", name, true, "Should the max value be modified?");
        float minimumValue = config.getFloat("min", name, (float)attribute.field_111120_a, -3.4028235E38f, Float.MAX_VALUE, "The minimum amount for the " + name + " attribute.");
        if (modifyMax) {
            attribute.field_111118_b = maximumValue;
        }
        if (modifyMin) {
            attribute.field_111120_a = minimumValue;
        }
        if (attribute.field_111120_a > attribute.field_111118_b) {
            throw new IllegalArgumentException("The " + name + " attribute was configured incorrectly! Minimum must not be greater than maximum!");
        }
        if (modifyMin || modifyMax) {
            log.debug("Modified {}. Min {} -> {} and Max {} -> {}", (Object)name, (Object)oldMin, (Object)attribute.field_111120_a, (Object)oldMax, (Object)attribute.field_111118_b);
        }
    }

    private float getAdjustedAmount(float amount) {
        return Math.max(amount, 65536.0f);
    }

    public void syncConfigData() {
        if (config.hasChanged()) {
            config.save();
        }
    }
}

